/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.vterm;

import com.ibm.hsc.vterm.VSerialHelper;
import com.ibm.hsc.vterm.VSerialInfoCIMClient;
import com.ibm.hsc.vterm.VSerialInfoHSClient;
import com.ibm.hsc.vterm.VSerialPartitionInfo;
import com.ibm.hsc.vterm.VSerialSystemInfo;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;

abstract class VSerialInfoClient {
    protected final VSerialHelper m_helper;
    protected final VSerialHelper.UPMapEntry m_entry;
    protected Subject m_subject;

    protected VSerialInfoClient(VSerialHelper vSerialHelper, VSerialHelper.UPMapEntry uPMapEntry) {
        this.m_helper = vSerialHelper;
        this.m_entry = uPMapEntry;
        this.m_subject = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void newInstance(VSerialHelper vSerialHelper, Object object) throws SecurityException {
        if (!(object instanceof VSerialHelper.UPMapEntry)) throw new SecurityException("Bad obj");
        VSerialHelper.UPMapEntry uPMapEntry = (VSerialHelper.UPMapEntry)object;
        if (!VSerialHelper.s_useCIM || VSerialHelper.s_allowRoot && "root".equals(uPMapEntry.getU())) {
            VSerialInfoHSClient.newInstance(vSerialHelper, object);
            return;
        } else {
            if (!VSerialHelper.s_useCIM || "root".equals(uPMapEntry.getU())) throw new SecurityException("Failed");
            VSerialInfoCIMClient.newInstance(vSerialHelper, object);
        }
    }

    public abstract VSerialSystemInfo[] getSystemInformation() throws SecurityException, UnsupportedOperationException;

    public abstract VSerialPartitionInfo[] getPartitionInformation(String var1) throws SecurityException, UnsupportedOperationException;

    protected boolean authenticate(String string) {
        try {
            LoginContext loginContext = new LoginContext(string, new VSerialCallbackHandler(this.m_entry.getU(), this.m_entry.getP()));
            loginContext.login();
            this.m_subject = loginContext.getSubject();
            return true;
        }
        catch (LoginException loginException) {
            return false;
        }
    }

    private class VSerialCallbackHandler
    implements CallbackHandler {
        private String m_u;
        private String m_p;

        public VSerialCallbackHandler(String string, String string2) {
            this.m_u = string;
            this.m_p = string2;
        }

        public void handle(Callback[] callbackArray) throws UnsupportedCallbackException {
            for (int i = 0; i < callbackArray.length; ++i) {
                Callback callback;
                if (callbackArray[i] instanceof NameCallback) {
                    callback = (NameCallback)callbackArray[i];
                    ((NameCallback)callback).setName(this.m_u);
                    continue;
                }
                if (callbackArray[i] instanceof PasswordCallback) {
                    callback = (PasswordCallback)callbackArray[i];
                    ((PasswordCallback)callback).setPassword(this.m_p.toCharArray());
                    continue;
                }
                throw new UnsupportedCallbackException(callbackArray[i]);
            }
        }
    }
}

